/** @file   overlayitem.cpp
 * @brief   Implementation of OverlayItem - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */
 
// Class automatically generated by Dev-C++ New Class wizard

#include "overlayitem.h" // class's header file
#include <allegro.h>
#include "www_assert.h"
#include "GfxManager.h"

namespace WeWantWar {


// class constructor
OverlayItem::OverlayItem( int x, int y, int w, int h ) :
  m_position( x, y ),
  m_opacity( 0 ),
  m_minOpacity( 0 ),
  m_maxOpacity( 200 )
{
  m_pBuffer = create_bitmap( w, h );
}


// class destructor
OverlayItem::~OverlayItem()
{
  if ( m_pBuffer != 0 ) {
    destroy_bitmap( m_pBuffer );
    m_pBuffer = 0;
  }
}



/** Sets the opaque - value
 */
void OverlayItem::opacity( OpacityVal opa )
{
  if ( opa < m_minOpacity ) {
    opa = m_minOpacity;
  }
  if ( opa > m_maxOpacity ) {
    opa = m_maxOpacity;
  }
  
  m_opacity = opa;
}



/** Positions this item.
 */
void OverlayItem::position( const eng2d::Vec2D& rPos )
{
  m_position = rPos;
}



/** Redraws the background buffer to screen.
 */
void OverlayItem::redraw( BITMAP* pB ) const
{
  if ( m_opacity <= 1 ) {
    return;
  }
  
  int x = static_cast<int>( m_position.x() );
  int y = static_cast<int>( m_position.y() );
  
  set_trans_blender( 0, 0, 0, m_opacity );
  draw_trans_sprite( pB, m_pBuffer, x, y );
}



/** Increases the opacity
 */
void OverlayItem::fadeIn( OpacityVal opa )
{
  m_opacity += opa;
  if ( m_opacity > m_maxOpacity ) {
    m_opacity = m_maxOpacity;
  }
}



/** Decreases the opacity
 */
void OverlayItem::fadeOut( OpacityVal opa )
{
  m_opacity -= opa;
  if ( m_opacity < m_minOpacity ) {
    m_opacity = m_minOpacity;
  }
}



/** Sets the minimum and maximum opacity values
 */
void OverlayItem::setOpacityRange( OpacityVal minOpa, OpacityVal maxOpa )
{
  WWW_ASSERT( minOpa <= maxOpa );
  m_minOpacity = minOpa;
  m_maxOpacity = maxOpa;
}



/** Returns the opaque-value.
 */
OverlayItem::OpacityVal OverlayItem::opacity() const
{
  return m_opacity;
}



/** Returns the position.
 */
eng2d::Vec2D OverlayItem::position() const
{
  return m_position;
}



/** Returns the pointer to background buffer.
 */
BITMAP* OverlayItem::getBuffer() const
{
  return m_pBuffer;
}

} // end of namespace
